-----
CREATE OR REPLACE FUNCTION tmp__group_user__add(IN _group VARCHAR, IN _user VARCHAR) RETURNS void AS $$
  BEGIN
    EXECUTE 'ALTER GROUP "' || _group || '" ADD USER "' || _user || '";';
    RETURN;
  END $$ LANGUAGE plpgsql;
---

  -- eigentliche Trigger-Funktion zur Verwendung an beliebiger  Tabelle
  CREATE OR REPLACE FUNCTION create__users() RETURNS void AS $f$
    DECLARE
      _users VARCHAR[];
      i integer;

    BEGIN
        -- Dokumentation und MD5-Passwortberechnung siehe "PSQL\0050 System\ZZ Users.sql"
        -- ACHTUNG: DEMO-Nutzerlogins (llv) siehe "PSQL\9700 Demodaten\DemoDaten.0050.LoginsUserConfig.sql"
        -- ACHTUNG: leere Passwörter in LLV werden auf lower(ll_db_usename) gesetzt ... ABER hier im DB-Login bleiben sie standardmäßig leer.
        --          Später beim Passwort-Ändern im Prodat wird ll_passwd UND DB-Password gesetzt (bei uns lokal wird DB-Passwort ignoriert, da Trusted, aber ll_passwd wird geprüft)

        -- SUPERUSER, da aktuell sonst nichtmal ein SELECT auf die einfachsten Tabellen möglich ist.
        -- z.B. "ERROR: permission denied for relation loginrole" gleich zu Beginn von DemoDaten.0050.LoginsUserConfig.sql
        PERFORM TSystem.create__user('DEMO',       $$ PASSWORD 'md5ed9f279431f9b27d8e26af0599bbdabe' $$);  -- Testbenutzer, Password siehe https://redmine.prodat-sql.de/projects/prodat-v-x/keys
        PERFORM TSystem.create__user('DEMODATA',   $$ SUPERUSER $$);  -- Testbenutzer, zum Anlegen der DEMO-Daten  (ohne Login > SET SESSION AUTHORIZATION) (OG mit 'NOLOGIN' findet USER in pg_user nicht)

        -- Mitarbeiterstamm anlegen (Tester)
        PERFORM TSystem.create__user('PRAKTIKANT', $$ $$);
        PERFORM TSystem.create__user('TC',         $$ PASSWORD 'md53cd2e8458a043a0f8aebe347182506c9' NOSUPERUSER $$);  -- PW=test
        -- Benutzer für Strukturanpassungen Datenbank aus TestComplete heraus
        PERFORM TSystem.create__user('TC-ADMIN',   $$ PASSWORD 'md53cd2e8458a043a0f8aebe347182506c9' SUPERUSER $$);  -- PW=test

        -- Mitarbeiterstamm anlegen (Mitarbeiter CIMPCS)
        -- Liste siehe LLV in DemoDaten.0050.LoginsUserConfig.sql
        PERFORM TSystem.create__user('ACJ',  $$ $$);
        PERFORM TSystem.create__user('AFL',  $$ $$);
        PERFORM TSystem.create__user('AKU',  $$ $$);
        PERFORM TSystem.create__user('AXS',  $$ $$);
        PERFORM TSystem.create__user('FS',   $$ $$);
        PERFORM TSystem.create__user('GEO',  $$ $$);
        PERFORM TSystem.create__user('MF',   $$ $$);
        PERFORM TSystem.create__user('MIJ',  $$ $$);
        PERFORM TSystem.create__user('RK',   $$ $$);
        PERFORM TSystem.create__user('987',  $$ $$);  -- ll_ad_krz=SCD
        PERFORM TSystem.create__user('STA',  $$ $$);

        -- Unternehmen CIMPCS anlegen
        PERFORM TSystem.create__user('CIMPCS', $$ $$);

        -- Sonstiges
        GRANT "SYS.DebiKrediDat"     TO "DEMODATA";
        GRANT "SYS.Lager-Lagerort"   TO "DEMODATA";
        GRANT "SYS.Personaldaten"    TO "DEMODATA"; -- darf Benutzer anlegen
        GRANT "SYS.Lager-Lagerort"   TO "TC-ADMIN";
        GRANT "SYS.Lager-Lagerort"   TO "TC";

        -- #16891
        _users := ARRAY['PRAKTIKANT', 'TC-ADMIN', 'ACJ', 'AFL', 'AKU', 'AXS', 'FS', 'GEO', 'MF', 'MIJ', 'RK', '987', 'STA'];
        FOR i IN 1..array_length(_users, 1) LOOP
           PERFORM tmp__group_user__add('SYS.Lager', _users[i]);
        END LOOP;
    END $f$ LANGUAGE plpgsql;

SELECT create__users();   --- #20803
---

DROP FUNCTION tmp__group_user__add(VARCHAR, VARCHAR);
---

DO $$
  DECLARE rec RECORD;
  BEGIN

    FOR rec IN SELECT * FROM pg_user -- WHERE usename NOT IN ( 'GEO' )  -- 'DSCHUCH'
    LOOP
        -- RAISE NOTICE '%', rec.usename;
        EXECUTE 'GRANT "SYS.Prodat-User" TO "' || rec.usename || '";';
    END LOOP;
END $$;

SELECT TSystem.grant__table_funktion_sequence_schema_privileg__to__rolle('SYS.Prodat-User');

-- nachfolgende 'DemoDaten.****.***.sql' ausführen als DEMO-Benutzer - siehe "PSQL\0050 System\ZZ Users.sql" > DEMO-Datenbank
/*
-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

...

-- END DEMO-SESSION + keine leeren Statements am Ende vom Erstellen der DB erlaubt.
RESET SESSION AUTHORIZATION;
SELECT true;
*/


-- DEMO-Nutzer löschen?
/*
REASSIGN OWNED BY "DEMO" TO "root";
DROP USER "DEMO";
*/
